/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.google.common.collect.Lists;
import com.tristankechlo.livingthings.config.entity.SnailConfig;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.Ingredients;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class SnailEntity
extends Animal
implements ILexiconEntry {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(SnailEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHELL_COLOR_F = SynchedEntityData.m_135353_(SnailEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHELL_COLOR_B = SynchedEntityData.m_135353_(SnailEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final ResourceLocation[] BODY_TEXTURES = new ResourceLocation[]{SnailEntity.textureLocation("snail_body_1.png")};
    private static final ResourceLocation[] SHELL_TEXTURES_B = new ResourceLocation[]{SnailEntity.textureLocation("snail_shell_b1.png"), SnailEntity.textureLocation("snail_shell_b2.png")};
    private static final ResourceLocation[] SHELL_TEXTURES_F = new ResourceLocation[]{SnailEntity.textureLocation("snail_shell_f1.png"), SnailEntity.textureLocation("snail_shell_f2.png")};

    public SnailEntity(EntityType<? extends Animal> type, Level worldIn) {
        super(type, worldIn);
    }

    public static boolean checkSnailSpawnRules(EntityType<SnailEntity> animal, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(LivingThingsTags.SNAIL_SPAWNABLE_ON) && SnailEntity.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    private static final ResourceLocation textureLocation(String name) {
        return new ResourceLocation("livingthings", "textures/entity/snail/" + name);
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        SnailEntity snailChild = (SnailEntity)ModEntityTypes.SNAIL.get().m_20615_((Level)world);
        if (entity == this) {
            snailChild.setShellColor(PatternType.FOREGROUND, this.getShellColor(PatternType.FOREGROUND));
            snailChild.setShellColor(PatternType.BACKGROUND, this.getShellColor(PatternType.BACKGROUND));
            snailChild.setVariant(this.getVariant());
            return snailChild;
        }
        RandomSource random = world.m_213780_();
        if (entity instanceof SnailEntity) {
            SnailEntity parentSnail = (SnailEntity)entity;
            ArrayList colors = Lists.newArrayList((Object[])new Integer[]{this.getShellColor(PatternType.FOREGROUND), this.getShellColor(PatternType.BACKGROUND), parentSnail.getShellColor(PatternType.FOREGROUND), parentSnail.getShellColor(PatternType.BACKGROUND)});
            snailChild.setShellColor(PatternType.FOREGROUND, (Integer)colors.get(random.m_188503_(4)));
            snailChild.setShellColor(PatternType.BACKGROUND, (Integer)colors.get(random.m_188503_(4)));
            short bodyVariant = random.m_188499_() ? this.getBodyVariant() : parentSnail.getBodyVariant();
            short shellVariant = !random.m_188499_() ? this.getShellVariant() : parentSnail.getShellVariant();
            snailChild.setVariant(bodyVariant, shellVariant);
        } else {
            SnailVariants preset = SnailVariants.random(random);
            snailChild.setShellColor(PatternType.FOREGROUND, preset.getForegroundColor());
            snailChild.setShellColor(PatternType.BACKGROUND, preset.getBackgroundColor());
            snailChild.setVariant(preset.getVariant());
        }
        return snailChild;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, SnailConfig.health()).m_22268_(Attributes.f_22279_, SnailConfig.movementSpeed());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        SnailVariants data = SnailVariants.random(worldIn.m_213780_());
        this.setVariant(data.getVariant());
        this.setShellColor(PatternType.FOREGROUND, data.getForegroundColor());
        this.setShellColor(PatternType.BACKGROUND, data.getBackgroundColor());
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredients.SNAIL_FOOD, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)SnailVariants.NORMAL.getVariant());
        this.f_19804_.m_135372_(SHELL_COLOR_F, (Object)SnailVariants.NORMAL.getForegroundColor());
        this.f_19804_.m_135372_(SHELL_COLOR_B, (Object)SnailVariants.NORMAL.getBackgroundColor());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128445_("SnailVariant"));
        this.setShellColor(PatternType.FOREGROUND, compound.m_128451_("ShellColorF"));
        this.setShellColor(PatternType.BACKGROUND, compound.m_128451_("ShellColorB"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("SnailVariant", this.getVariant());
        compound.m_128405_("ShellColorF", this.getShellColor(PatternType.FOREGROUND));
        compound.m_128405_("ShellColorB", this.getShellColor(PatternType.BACKGROUND));
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(LivingThingsTags.SNAIL_FOOD);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof DyeItem) {
            DyeColor color = ((DyeItem)stack.m_41720_()).m_41089_();
            if (player.m_6047_()) {
                this.setShellColor(PatternType.FOREGROUND, color);
            } else {
                this.setShellColor(PatternType.BACKGROUND, color);
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.93f;
    }

    public ResourceLocation getBodyTexture() {
        return BODY_TEXTURES[this.getBodyVariant()];
    }

    private short getBodyVariant() {
        return (short)(this.getVariant() >> 16);
    }

    public ResourceLocation getShellPatternTexture(PatternType type) {
        return type == PatternType.FOREGROUND ? SHELL_TEXTURES_F[this.getShellVariant()] : SHELL_TEXTURES_B[this.getShellVariant()];
    }

    private short getShellVariant() {
        return (short)this.getVariant();
    }

    public float[] getShellColorScheme(PatternType type) {
        int colorValue = this.getShellColor(type);
        int i = (colorValue & 0xFF0000) >> 16;
        int j = (colorValue & 0xFF00) >> 8;
        int k = (colorValue & 0xFF) >> 0;
        return new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void setVariant(short bodyVariant, short shellVariant) {
        this.setVariant(bodyVariant << 16 | shellVariant & 0xFFFF);
    }

    public int getShellColor(PatternType type) {
        if (type == PatternType.FOREGROUND) {
            return (Integer)this.f_19804_.m_135370_(SHELL_COLOR_F);
        }
        return (Integer)this.f_19804_.m_135370_(SHELL_COLOR_B);
    }

    public void setShellColor(PatternType type, int color) {
        if (type == PatternType.FOREGROUND) {
            this.f_19804_.m_135381_(SHELL_COLOR_F, (Object)color);
        } else if (type == PatternType.BACKGROUND) {
            this.f_19804_.m_135381_(SHELL_COLOR_B, (Object)color);
        }
    }

    public void setShellColor(PatternType type, DyeColor color) {
        float[] colors = color.m_41068_();
        int red = Math.round(colors[0] * 255.0f);
        int green = Math.round(colors[1] * 255.0f);
        int blue = Math.round(colors[2] * 255.0f);
        this.setShellColor(type, FastColor.ARGB32.m_13660_((int)255, (int)red, (int)green, (int)blue));
    }

    public int m_5792_() {
        return SnailConfig.maxSpawnedInChunk();
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.SNAIL;
    }

    public static enum PatternType {
        FOREGROUND,
        BACKGROUND;

    }

    static enum SnailVariants {
        NORMAL(0, 0, 11693105, 8209952),
        GREEN(0, 0, 412975, 2129982),
        PURPLE(0, 0, 6488099, 10238043),
        BLUE(0, 0, 4857561, 6447075),
        RED(0, 0, 10367513, 13586001),
        NORMAL_2(0, 1, 9847813, 7352576);

        private final int variant;
        private final int colorForeground;
        private final int colorBackground;
        private static final SnailVariants[] VALUES;

        private SnailVariants(int bodyVariant, int shellVariant, int colorb, int colorf) {
            this.variant = bodyVariant << 16 | shellVariant & 0xFFFF;
            this.colorBackground = SnailVariants.opaque(colorb);
            this.colorForeground = SnailVariants.opaque(colorf);
        }

        public int getVariant() {
            return this.variant;
        }

        public int getForegroundColor() {
            return this.colorForeground;
        }

        public int getBackgroundColor() {
            return this.colorBackground;
        }

        public static SnailVariants random(RandomSource rand) {
            return VALUES[rand.m_188503_(VALUES.length)];
        }

        public static int opaque(int color) {
            return color | 0xFF000000;
        }

        static {
            VALUES = SnailVariants.values();
        }
    }
}

